# Sensory Sim Pack (Pinned & Reproducible)

**Status:** ready to ship • **Date:** 2025-10-25

This folder pins down the sensory demos (Touch, Vision, Sound) so they are **reproducible** and aligned with the V2 governance:

- Engine: **selectors → gates → hinge fit** `F(W,Q)=0` (lexicographic: hard gates → d_out → d_in → d_x; tiebreak = fewest acts; seed after feasibility)
- Composition: **no‑skip** (any `0→+2` must factor `0→+1→+2`)
- **No curve/pivot/logistic multipliers** in control; if “UGM” appears, include the literal phrase **“UGM is a +1 proxy.”**
- Gates (Θ, κ) are **feasibility**, not constants; instruments can shift them.
- Conversion `c` is the shared 0↔+1 map; invariants come from composition.

## Folder map

```
sim/
  README.md                                  ← this file
  predicates/
    touch_merge_predicate.md                 ← Touch rule (3-tap smoother + peak-count)
    vision_steady_predicate.md               ← Vision rule (DC-fraction; lens constant k)
    sound_detection_predicate.md             ← Sound rule (probe+MF; fixed p_FA)
  schemas/
    manifest.schema.json                     ← JSON schema for run manifests
  templates/
    manifest.template.json                   ← Fill and commit per run
  acceptance/
    requirements.json                        ← Machine-readable acceptance gates
  scripts/
    ci_lints.sh                              ← Lints for governance & content drift
    validate_manifest.py                     ← JSON-schema validation for manifest
    check_acceptance.py                      ← Check results against acceptance gates
    recenter_harness.md                      ← How to run re-centering checks
    preflight_sound.md                       ← Sound preflight (coherence & p_FA)
```

## Quickstart (4 steps)

1. **Fill the manifest** from `templates/manifest.template.json` and save as `manifest.json` in the run folder.
2. **Run simulations** (engine unchanged). Record results to `results.json` and artifacts per the manifest schema.
3. **Preflight & acceptance**
   - `python scripts/validate_manifest.py manifest.json schemas/manifest.schema.json`
   - `python scripts/check_acceptance.py results.json acceptance/requirements.json`
4. **CI lints**
   - `bash scripts/ci_lints.sh`  (configure paths at top of the script)

If any check fails, fix the **predicate** shape or the **instrument calibration** (not the engine).
